

% steady-state without shocks, but with ZLB


Vss = zeros(n_x,n_pi) ;
% optpolss = zeros(n_x,n_pi) ;
% int_polss = zeros(n_x,n_pi) ;
% x_polss = zeros(n_x,n_pi) ;
% pi_polss = zeros(n_x,n_pi) ;
uuu = kappa^2+lambda*(1-beta*ksi^2) ;
VV = (- uuu + sqrt( uuu^2+4*lambda*ksi^2*beta*kappa^2))/(2*beta*kappa^2) ;
for i=1:n_x;
    Vss(i,:) = VV/2*grid_pi.^2 ;
end

grid_x_large = repmat(grid_x,[n_i 1 n_pi]) ;
grid_i_large = repmat(grid_i',[1 n_x n_pi]) ;
grid_pi_large = permute(repmat(grid_pi',[1 n_i n_x]),[2 3 1] ) ;
potential_x_todayK = delta*grid_x_large - 1/sigma*(grid_i_large-grid_pi_large) ;
potential_x_today = potential_x_todayK + (rho_end)/sigma ;
potential_pi_today = ksi*grid_pi_large + kappa*potential_x_today ; % +u

potential_x_today = max(potential_x_today,lx) ; % does this matter
% potential_x_today = min(potential_x_today,ux) ; % does this matter

potential_pi_today = max(potential_pi_today,lpi) ; % does this matter
% potential_pi_today = min(potential_pi_today,upi) ; % does this matter
currentobj = .5*(potential_pi_today.^2 + lambda*potential_x_today.^2) ;

V = Vss ;
err = 1 ; prec = 1e-7 ; iter = 0 ; maxiter = 1e3 ;
relax = 0 ;

while err>prec
    
    iter = iter + 1 ;
    
    futureval = interp2(grid_pi,grid_x,V,potential_pi_today,potential_x_today,'linear') ;
    
    W = min( currentobj + beta*futureval,[],1 );
    W = squeeze(W) ;
    
    err = max(max(abs(W-V))) ;
    
    V = relax*V+(1-relax)*W ;
    
    if rem(iter,50)==1
        disp('iter')
        disp(iter)
        disp('error')
        disp(err)
    end
    
end

disp('iter')
disp(iter)
disp('err')
disp(err)